/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.IVWLinkerTable;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMLink;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class VWLinkerDocTableModel
extends DefaultTableModel
implements IVWLinkerTable {
    public static final int COLUMN_LINK = 0;
    public static final int COLUMN_WORKFLOW_TITLE = 1;
    public static final int COLUMN_VERSION = 2;
    public static final int COLUMN_SUBJECT = 3;
    public static final int COLUMN_LAUNCH_TYPE = 4;
    public IVWIDMLibrary m_library = null;

    public VWLinkerDocTableModel() {
        this.addColumn(VWResource.LinkName);
        this.addColumn(VWResource.WorkflowTitle);
        this.addColumn(VWResource.Version);
        this.addColumn(VWResource.WorkflowSubject);
        this.addColumn(VWResource.LaunchType);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public DefaultTableModel getDefaultTableModel() {
        return this;
    }

    public void addLink(IVWIDMLink link) throws Exception {
        if (link == null) {
            throw new Exception("VWLinkerDocTableModel: addLink null link");
        }
        Vector<Object> aRow = new Vector<Object>();
        aRow.addElement(link);
        aRow.addElement(link.getWfTitle());
        String wfId = link.getWflDocID();
        aRow.addElement(wfId.substring(wfId.lastIndexOf(58) + 1));
        aRow.addElement(link.getSubject());
        String eventType = null;
        switch (link.getEventType()) {
            case 0: {
                eventType = VWResource.Manual;
                break;
            }
            case 2: {
                eventType = VWResource.OnAdd;
                break;
            }
            case 1: {
                eventType = VWResource.OnCheckin;
            }
        }
        aRow.addElement(eventType);
        this.addRow(aRow);
    }

    public IVWIDMLink getLink(int row) throws Exception {
        IVWIDMLink aLink = null;
        aLink = (IVWIDMLink)this.getValueAt(row, 0);
        return aLink;
    }

    public IVWIDMLibrary getLibrary() {
        return this.m_library;
    }

    public void setLibrary(IVWIDMLibrary lib) {
        this.m_library = lib;
    }

    public void setWfTitle(String title, int row) {
        this.setValueAt(title, row, 1);
    }

    public void setWFVersion(String docId, int row) {
        String wfVer = docId.substring(docId.lastIndexOf(58) + 1);
        this.setValueAt(wfVer, row, 2);
    }

    public void setDocName(String docName, int row) {
    }

    public void setLaunchType(int type, int row) {
        String eventType = null;
        switch (type) {
            case 0: {
                eventType = VWResource.Manual;
                break;
            }
            case 2: {
                eventType = VWResource.OnAdd;
                break;
            }
            case 1: {
                eventType = VWResource.OnCheckin;
            }
        }
        this.setValueAt(eventType, row, 4);
    }

    public void setSubject(String subject, int row) {
        this.setValueAt(subject, row, 3);
    }
}

